package ru.yandex.direct.ydb.table;


import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.ydb.column.Column;

public class Index<T extends Table> {
    private final T table;
    private final List<Column> columns;
    private final String indexName;
    private final List<String> columnNames;
    private final String alias;

    public Index(T table, Column columns, String indexName) {
        this(table, List.of(columns), indexName);
    }

    public Index(T table, List<Column> columns, String indexName) {
        this(table, columns, indexName, table.getRealName() + "_" + indexName);
    }

    public Index(T table, List<Column> columns, String indexName, String alias) {
        this.table = table;
        this.columns = columns;
        this.indexName = indexName;
        this.columnNames = columns.stream().map(Column::getName).collect(Collectors.toList());
        this.alias = alias;
    }

    public Index as(String alias) {
        return new Index(table, columns, indexName, alias);
    }

    public List<String> getColumnNames() {
        return columnNames;
    }

    public String getAlias() {
        return alias;
    }

    public String getIndexName() {
        return indexName;
    }
}
