package ru.yandex.direct.ydb.table;

import java.util.List;

import com.yandex.ydb.table.description.TableDescription;

import ru.yandex.direct.ydb.column.Column;

import static java.util.stream.Collectors.toList;

public abstract class Table extends TableExpression {

    private Index useIndex;

    public Table(String realName) {
        super(realName);
    }

    public Table(String realName, String alias) {
        super(realName, alias);
    }

    public abstract List<Column> getColumns();


    protected TableDescription.Builder tableDescriptionBuilder() {
        var columns = getColumns();
        var pkNames = columns.stream().filter(Column::isPk).map(Column::getColumnName).collect(toList());
        var tableDescriptionBuilder = TableDescription.newBuilder();
        for (var column : columns) {
            if (column.isNullable()) {
                tableDescriptionBuilder.addNullableColumn(column.getColumnName(), column.getType());
            } else {
                tableDescriptionBuilder.addNonnullColumn(column.getColumnName(), column.getType());
            }
        }

        tableDescriptionBuilder.setPrimaryKeys(pkNames);
        return tableDescriptionBuilder;
    }

    public TableDescription getDescription() {
        return tableDescriptionBuilder().build();
    }
}
