package ru.yandex.direct.ydb.table;

import java.util.List;

import ru.yandex.direct.ydb.builder.Param;

public abstract class TableExpression {

    private final String realName;
    private final String tableDeclare;
    private final String referenceTableName;
    private final String alias;

    public TableExpression(String realName) {
        this(realName, null);
    }

    public TableExpression(String realName, String alias) {
        this(realName, realName, alias);
    }

    public TableExpression(String realName, String tableDeclare, String alias) {
        this.realName = realName;
        this.alias = alias;
        if (alias != null) {
            this.tableDeclare = tableDeclare + " AS " + alias;
            this.referenceTableName = alias;
        } else {
            this.tableDeclare = realName;
            this.referenceTableName = realName;
        }
    }


    public List<Param> getParams() {
        return List.of();
    }

    public String getRealName() {
        return realName;
    }

    public String getReferenceTableName() {
        return referenceTableName;
    }

    public String getTableDeclare() {
        return tableDeclare;
    }

    public String getAlias() {
        return alias;
    }
}
