package ru.yandex.direct.ydb.table;

import java.util.List;

import com.yandex.ydb.table.description.TableDescription;

public abstract class TableWithIndexes extends Table {
    private Index useIndex = null;

    public TableWithIndexes(String realName, String alias) {
        super(realName, alias);
    }

    public abstract List<Index> getIndexes();

    @Override
    public String getTableDeclare() {
        if (useIndex == null) {
            return super.getTableDeclare();
        } else {
            return getRealName() + " view " + useIndex.getIndexName() + " AS " + getAlias();
        }
    }

    public Table withIndex(Index i) {
        var newInstance = getInstance(this.getRealName(), i.getAlias());
        newInstance.setUseIndex(i);
        return newInstance;
    }


    /**
     * Метод, создающий новый инстанс таблицы с именем realName и алиасом alias, сохраняющий текущие настройки
     * В первую очередь нужен, чтобы можно было использовать запросы по глобальному индексу
     */
    protected abstract TableWithIndexes getInstance(String realName, String alias);

    public Table as(String alias) {
        var newInstance = getInstance(getRealName(), alias);
        newInstance.setUseIndex(this.useIndex);
        return newInstance;
    }

    public void setUseIndex(Index useIndex) {
        this.useIndex = useIndex;
    }

    @Override
    protected TableDescription.Builder tableDescriptionBuilder() {
        var builder = super.tableDescriptionBuilder();
        var indexes = getIndexes();
        indexes.forEach(index -> builder.addGlobalIndex(index.getIndexName(), index.getColumnNames()));
        return builder;
    }
}
