package ru.yandex.direct.ydb.table.temptable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Value;

import ru.yandex.direct.ydb.builder.Param;
import ru.yandex.direct.ydb.builder.valuecreator.ValueCreator;
import ru.yandex.direct.ydb.column.TempColumn;
import ru.yandex.direct.ydb.table.TableExpression;

public class FilledTempTable extends TableExpression {
    private final List<Value> rawValues;
    private final TempColumn[] columns;
    private final StructType rawType;
    private final ListType tableType;
    private final String nameToReplace;
    private final String aliasedName;

    FilledTempTable(TempTable tempTable) {
        super(tempTable.getRealTableName(), tempTable.getName());
        this.rawValues = new ArrayList<>();
        this.columns = tempTable.getColumns();
        this.rawType = tempTable.getRawType();
        this.tableType = tempTable.getTableType();
        this.nameToReplace = tempTable.getNameToReplace();
        this.aliasedName = tempTable.getName();
    }

    void fillInternal(Object... objects) {
        if (objects.length != columns.length) {
            throw new IllegalStateException("Values number shout be equal to columns number, actual values - " + objects.length + " columns - " + columns.length);
        }
        Map<String, Value> valuesMap = new HashMap<>();
        for (int i = 0; i < columns.length; i++) {
            var currentColumn = columns[i];
            var object = objects[i];
            ValueCreator function = currentColumn.getValueCreator();
            function.toYdb(object);
            valuesMap.put(currentColumn.getColumnName(), function.toYdb(object));
        }
        var rawValue = rawType.newValue(valuesMap);
        rawValues.add(rawValue);
    }

    @Override
    public List<Param> getParams() {
        return List.of(new Param(nameToReplace, tableType, tableType.newValue(rawValues)));
    }
}
