package ru.yandex.direct.ydb.table.temptable;

import java.util.Arrays;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.column.AbstractColumn;
import ru.yandex.direct.ydb.column.TempColumn;

import static java.util.stream.Collectors.toMap;

public class TempColumns {
    private final TempColumn[] columns;
    private final ListType tableType;
    private final StructType rawType;

    TempColumns(TempColumn... columns) {

        this.columns = columns;

        var nameTypeMap = Arrays.stream(this.columns).collect(toMap(AbstractColumn::getColumnName,
                this::getColumnType));
        this.rawType = StructType.of(nameTypeMap);
        this.tableType = ListType.of(rawType);
    }

    protected Type getColumnType(AbstractColumn column) {
        if (column.isNullable()) {
            return column.getType().makeOptional();
        } else {
            return column.getType();
        }
    }
}
