package ru.yandex.direct.ydb.table.temptable;

import java.util.Arrays;

import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.direct.ydb.column.AbstractColumn;
import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.column.TempColumn;

import static java.util.stream.Collectors.toMap;

public class TempTable {

    private final TempColumn[] columns;
    private String name;
    private final String nameToReplace;
    private final String realTableName;
    private final ListType tableType;
    private final StructType rawType;

    TempTable(TempTableDescription tempTableDescription, TempColumn<?>... tempColumns) {
        this.nameToReplace = tempTableDescription.getNameToReplace();
        this.realTableName = tempTableDescription.getRealTableName();
        this.name = tempTableDescription.getAliasedName();
        this.columns = tempColumns;
        var nameTypeMap = Arrays.stream(this.columns).collect(toMap(AbstractColumn::getColumnName,
                this::getColumnType));
        this.rawType = StructType.of(nameTypeMap);
        this.tableType = ListType.of(rawType);
    }

    TempTable(TempTableDescription tempTableDescription, Column<?>... columns) {
        this.nameToReplace = tempTableDescription.getNameToReplace();
        this.realTableName = tempTableDescription.getRealTableName();
        this.name = tempTableDescription.getAliasedName();
        this.columns = copyColumns(tempTableDescription, columns);
        var nameTypeMap = Arrays.stream(this.columns).collect(toMap(AbstractColumn::getColumnName,
                this::getColumnType));
        this.rawType = StructType.of(nameTypeMap);
        this.tableType = ListType.of(rawType);
    }

    private TempColumn[] copyColumns(TempTableDescription tempTableDescription, Column... columns) {
        TempColumn[] result = new TempColumn[columns.length];
        for (int idx = 0; idx < columns.length; idx++) {
            var column = columns[idx];
            TempColumn tempColumn = TempColumn.tempCol(tempTableDescription, column);
            result[idx] = tempColumn;
        }
        return result;
    }

    protected Type getColumnType(AbstractColumn column) {
        if (column.isNullable()) {
            return column.getType().makeOptional();
        } else {
            return column.getType();
        }
    }

    public TempColumn[] getColumns() {
        return columns;
    }

    public String getName() {
        return name;
    }

    public String getNameToReplace() {
        return nameToReplace;
    }

    public ListType getTableType() {
        return tableType;
    }

    public StructType getRawType() {
        return rawType;
    }

    public String getRealTableName() {
        return realTableName;
    }

    public static <T1> TempTable1<T1> tempTable(TempTableDescription tableDescription,
                                                TempColumn<T1> column) {
        return new TempTable1<>(tableDescription, column);
    }

    public static <T1> TempTable1<T1> tempTable(TempTableDescription tableDescription,
                                                Column<T1> column) {
        return new TempTable1<>(tableDescription, column);
    }

    public static <T1, T2> TempTable2<T1, T2> tempTable(TempTableDescription tableDescription,
                                                        TempColumn<T1> column1,
                                                        TempColumn<T2> column2) {
        return new TempTable2<>(tableDescription, column1, column2);
    }

    public static <T1, T2> TempTable2<T1, T2> tempTable(Column<T1> column1,
                                                        Column<T2> column2) {
        return new TempTable2<>(new TempTableDescription(), column1, column2);
    }

    public static <T1, T2> TempTable2<T1, T2> tempTable(TempTableDescription tableDescription,
                                                        Column<T1> column1,
                                                        Column<T2> column2) {
        return new TempTable2<>(tableDescription, column1, column2);
    }

    public static <T1, T2, T3> TempTable3<T1, T2, T3> tempTable(TempTableDescription tableDescription,
                                                                TempColumn<T1> column1,
                                                                TempColumn<T2> column2,
                                                                TempColumn<T3> column3) {
        return new TempTable3<>(tableDescription, column1, column2, column3);
    }


    public static <T1, T2, T3> TempTable3<T1, T2, T3> tempTable(TempTableDescription tableDescription,
                                                                Column<T1> column1,
                                                                Column<T2> column2,
                                                                Column<T3> column3) {
        return new TempTable3<>(tableDescription, column1, column2, column3);
    }

    public static <T1, T2, T3> TempTable3<T1, T2, T3> tempTable(Column<T1> column1,
                                                                Column<T2> column2,
                                                                Column<T3> column3) {
        return new TempTable3<>(new TempTableDescription(), column1, column2, column3);
    }

    public static <T1, T2, T3, T4> TempTable4<T1, T2, T3, T4> tempTable(TempTableDescription tableDescription,
                                                                        TempColumn<T1> column1,
                                                                        TempColumn<T2> column2,
                                                                        TempColumn<T3> column3,
                                                                        TempColumn<T4> column4) {
        return new TempTable4<>(tableDescription, column1, column2, column3, column4);
    }


    public static <T1, T2, T3, T4> TempTable4<T1, T2, T3, T4> tempTable(TempTableDescription tableDescription,
                                                                        Column<T1> column1,
                                                                        Column<T2> column2,
                                                                        Column<T3> column3,
                                                                        Column<T4> column4) {
        return new TempTable4<>(tableDescription, column1, column2, column3, column4);
    }

    public static <T1, T2, T3, T4, T5> TempTable5<T1, T2, T3, T4, T5> tempTable(TempTableDescription tableDescription,
                                                                                TempColumn<T1> column1,
                                                                                TempColumn<T2> column2,
                                                                                TempColumn<T3> column3,
                                                                                TempColumn<T4> column4,
                                                                                TempColumn<T5> column5) {
        return new TempTable5<>(tableDescription, column1, column2, column3, column4, column5);
    }


    public static <T1, T2, T3, T4, T5> TempTable5<T1, T2, T3, T4, T5> tempTable(TempTableDescription tableDescription,
                                                                                Column<T1> column1,
                                                                                Column<T2> column2,
                                                                                Column<T3> column3,
                                                                                Column<T4> column4,
                                                                                Column<T5> column5) {
        return new TempTable5<>(tableDescription, column1, column2, column3, column4, column5);
    }

    public static <T1, T2, T3, T4, T5> TempTable5<T1, T2, T3, T4, T5> tempTable(
            Column<T1> column1,
            Column<T2> column2,
            Column<T3> column3,
            Column<T4> column4,
            Column<T5> column5) {
        return new TempTable5<>(new TempTableDescription(), column1, column2, column3, column4, column5);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> TempTable8<T1, T2, T3, T4, T5, T6, T7, T8> tempTable(TempTableDescription tableDescription, TempColumn<T1> column1,
                                                                                                        TempColumn<T2> column2,
                                                                                                        TempColumn<T3> column3, TempColumn<T4> column4, TempColumn<T5> column5,
                                                                                                        TempColumn<T6> column6, TempColumn<T7> column7, TempColumn<T8> column8) {
        return new TempTable8<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8);
    }


    public static <T1, T2, T3, T4, T5, T6, T7, T8> TempTable8<T1, T2, T3, T4, T5, T6, T7, T8> tempTable(TempTableDescription tableDescription, Column<T1> column1,
                                                                                                        Column<T2> column2,
                                                                                                        Column<T3> column3, Column<T4> column4, Column<T5> column5,
                                                                                                        Column<T6> column6, Column<T7> column7, Column<T8> column8) {
        return new TempTable8<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> TempTable8<T1, T2, T3, T4, T5, T6, T7, T8> tempTable(Column<T1> column1,
                                                                                                        Column<T2> column2,
                                                                                                        Column<T3> column3, Column<T4> column4, Column<T5> column5,
                                                                                                        Column<T6> column6, Column<T7> column7, Column<T8> column8) {
        return new TempTable8<>(new TempTableDescription(), column1, column2, column3, column4, column5, column6,
                column7,
                column8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> TempTable10<T1, T2, T3, T4, T5, T6, T7, T8, T9,
            T10> tempTable(TempTableDescription tableDescription, TempColumn<T1> column1,
                           TempColumn<T2> column2,
                           TempColumn<T3> column3, TempColumn<T4> column4, TempColumn<T5> column5,
                           TempColumn<T6> column6, TempColumn<T7> column7, TempColumn<T8> column8,
                           TempColumn<T9> column9, TempColumn<T10> column10) {
        return new TempTable10<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8, column9, column10);
    }


    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> TempTable10<T1, T2, T3, T4, T5, T6, T7, T8, T9,
            T10> tempTable(TempTableDescription tableDescription, Column<T1> column1,
                           Column<T2> column2,
                           Column<T3> column3, Column<T4> column4, Column<T5> column5,
                           Column<T6> column6, Column<T7> column7, Column<T8> column8,
                           Column<T9> column9, Column<T10> column10) {
        return new TempTable10<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8,
                column9, column10);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> TempTable13<T1, T2, T3, T4, T5, T6, T7, T8,
            T9, T10, T11, T12, T13> tempTable(TempTableDescription tableDescription, TempColumn<T1> column1,
                                              TempColumn<T2> column2,
                                              TempColumn<T3> column3, TempColumn<T4> column4, TempColumn<T5> column5,
                                              TempColumn<T6> column6, TempColumn<T7> column7, TempColumn<T8> column8,
                                              TempColumn<T9> column9, TempColumn<T10> column10,
                                              TempColumn<T11> column11,
                                              TempColumn<T12> column12, TempColumn<T13> column13) {
        return new TempTable13<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8, column9, column10, column11, column12, column13);
    }


    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> TempTable13<T1, T2, T3, T4, T5, T6, T7, T8,
            T9, T10, T11, T12, T13> tempTable(TempTableDescription tableDescription, Column<T1> column1,
                                              Column<T2> column2,
                                              Column<T3> column3, Column<T4> column4, Column<T5> column5,
                                              Column<T6> column6, Column<T7> column7, Column<T8> column8,
                                              Column<T9> column9, Column<T10> column10, Column<T11> column11,
                                              Column<T12> column12, Column<T13> column13) {
        return new TempTable13<>(tableDescription, column1, column2, column3, column4, column5, column6, column7,
                column8,
                column9, column10, column11, column12, column13);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> TempTable13<T1, T2, T3, T4, T5, T6, T7, T8,
            T9, T10, T11, T12, T13> tempTable(Column<T1> column1, Column<T2> column2,
                                              Column<T3> column3, Column<T4> column4, Column<T5> column5,
                                              Column<T6> column6, Column<T7> column7, Column<T8> column8,
                                              Column<T9> column9, Column<T10> column10, Column<T11> column11,
                                              Column<T12> column12, Column<T13> column13) {
        return new TempTable13<>(new TempTableDescription(), column1, column2, column3, column4, column5, column6, column7,
                column8,
                column9, column10, column11, column12, column13);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> TempTable14<T1, T2, T3, T4, T5, T6, T7, T8,
            T9, T10, T11, T12, T13, T14> tempTable(TempColumn<T1> column1,
                                              TempColumn<T2> column2,
                                              TempColumn<T3> column3, TempColumn<T4> column4, TempColumn<T5> column5,
                                              TempColumn<T6> column6, TempColumn<T7> column7, TempColumn<T8> column8,
                                              TempColumn<T9> column9, TempColumn<T10> column10,
                                              TempColumn<T11> column11,
                                              TempColumn<T12> column12, TempColumn<T13> column13, TempColumn<T14> column14) {
        return new TempTable14<>(new TempTableDescription(), column1, column2, column3, column4, column5, column6, column7,
                column8, column9, column10, column11, column12, column13, column14);
    }


    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> TempTable14<T1, T2, T3, T4, T5, T6, T7, T8,
            T9, T10, T11, T12, T13, T14> tempTable(Column<T1> column1,
                                              Column<T2> column2,
                                              Column<T3> column3, Column<T4> column4, Column<T5> column5,
                                              Column<T6> column6, Column<T7> column7, Column<T8> column8,
                                              Column<T9> column9, Column<T10> column10, Column<T11> column11,
                                              Column<T12> column12, Column<T13> column13, Column<T14> column14) {
        return new TempTable14<>(new TempTableDescription(), column1, column2, column3, column4, column5, column6, column7,
                column8,
                column9, column10, column11, column12, column13, column14);
    }
}
