package ru.yandex.direct.ydb.table.temptable

import ru.yandex.direct.ydb.column.Column

class TempTableBuilder {
    private val columns: MutableList<Column<*>> = mutableListOf()
    private val values: MutableList<MutableList<Any?>> = mutableListOf(mutableListOf())

    private var firstRecord = true
    private var description: TempTableDescription? = null

    fun description(description: TempTableDescription) {
        this.description = description
    }

    fun <T> value(column: Column<T>, value: T) {
        val index = values.last().size

        if (firstRecord) {
            columns.add(column)
        } else {
            if (index >= columns.size || column != columns[index]) {
                throw IllegalStateException("New record does not match the first one")
            }
        }

        values.last().add(value)
    }

    fun newRecord() {
        check(values.last().size == columns.size) { "Current record is not full" }

        firstRecord = false
        values.add(mutableListOf())
    }

    fun build(): FilledTempTable {
        // Допускается вызов newRecord после создания последней записи
        if (values.size > 1 && values.last().isEmpty()) {
            values.removeLast()
        } else {
            check(values.last().size == columns.size) { "Last record is not full" }
        }

        val tempTableDescription: TempTableDescription = description ?: TempTableDescription()
        val tempTable = TempTable(tempTableDescription, *this.columns.toTypedArray())
        val filledTempTable = FilledTempTable(tempTable)
        values.forEach { record ->
            filledTempTable.fillInternal(*record.toTypedArray())
        }
        return filledTempTable
    }

    companion object {
        fun buildTempTable(block: TempTableBuilder.() -> Unit): FilledTempTable {
            return TempTableBuilder().apply(block).build()
        }
    }
}
