package ru.yandex.direct.ydb.table.temptable;

public class TempTableDescription {
    private static final String DECLARATION_TEMPLATE = "AS_TABLE(%s)";

    private static final String DEFAULT_TABLE_NAME = "temp_table";
    private final String nameToReplace;
    private final String realTableName;
    private final String name;

    public TempTableDescription(String name) {
        this.nameToReplace = "$" + name;
        this.realTableName = getRealTableName(nameToReplace);
        this.name = name;
    }

    public TempTableDescription() {
        this(DEFAULT_TABLE_NAME);
    }


    public String getReferenceTableName() {
        return name;
    }

    String getRealTableName() {
        return realTableName;
    }

    public String getAliasedName() {
        return name;
    }

    public String getNameToReplace() {
        return nameToReplace;
    }

    private static String getRealTableName(String name) {
        return String.format(DECLARATION_TEMPLATE, name);
    }
}
