package ru.yandex.direct.yql.client

import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.http.GET
import ru.yandex.direct.http.smart.http.Path
import ru.yandex.direct.http.smart.http.Query
import ru.yandex.direct.yql.client.model.OperationResultResponse
import ru.yandex.direct.yql.client.model.OperationsResponse

interface YqlApi {
    @GET("/operations?page_size=100")
    @Json
    fun operations(@Query("filters") filters: String, @Query("page") page: Int): Call<OperationsResponse>

    @GET("operations/{id}/results?filters=PLAN,PROGRESS&columns_preset=false")
    @Json
    fun getOperationResult(@Path("id") id: String): Call<OperationResultResponse>
}
