package ru.yandex.direct.yql.client

import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.yql.client.model.OperationResultResponse
import ru.yandex.direct.yql.client.model.OperationsResponse
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster

class YqlClient(
    url: String?,
    ytProvider: YtProvider,
    fetcherFactory: ParallelFetcherFactory
) {
    /**
     * Пока что сделано по-простому -- берутся настройки с Hahn, так как они идентичны на всех кластерах,
     * то есть имеют одного пользователя и, соответственно, токен
     *
     * Если пользователи будут разные -- стоит переделать
     */
    private val clusterConfig = ytProvider.getClusterConfig(YtCluster.HAHN)

    private var api = Smart.builder()
        .withParallelFetcherFactory(fetcherFactory)
        .addHeaderConfigurator { h -> h.add("Authorization", "OAuth " + clusterConfig.yqlToken) }
        .withProfileName("yql-api")
        .withBaseUrl(url)
        .build()
        .create(YqlApi::class.java)

    fun getUser(): String = clusterConfig.user

    fun operations(filters: String, page: Int): OperationsResponse {
        return api.operations(filters, page).execute().success
    }

    fun getOperationResult(id: String): OperationResultResponse {
        return api.getOperationResult(id).execute().success
    }

}
