package ru.yandex.direct.yql.client.model

import com.fasterxml.jackson.annotation.JsonProperty

data class OperationResultResponse(
    val id: String? = null,
    val plan: Plan? = null,
    val progress: Map<String, ProgressItem>? = null,
)

data class Plan(
    @field:JsonProperty("Basic")
    val basic: Basic? = null,

    @field:JsonProperty("Detailed")
    val detailed: Detailed? = null,
)

data class Basic(
    val nodes: List<NodesItem>? = null,
)

data class NodesItem(
    val type: String? = null
)

class Detailed {
    @JsonProperty("Providers")
    var providers: List<Provider>? = null
}

class Provider {
    @JsonProperty("Cluster")
    var cluster: String? = null
}

data class ProgressItem(

    @field:JsonProperty("total")
    val total: Int? = null,
)
