package ru.yandex.direct.ytwrapper;

import java.nio.file.Paths;
import java.util.UUID;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Вспомогательные функции для работы с путями Yt
 */
@ParametersAreNonnullByDefault
public class YtPathUtil {
    public static final String TEMPORARY_NODE_NAME = "tmp";
    public static final String TEMPORARY_TABLES_STORAGE = "//" + TEMPORARY_NODE_NAME + "/directytwrapper";

    private YtPathUtil() {
    }

    /**
     * Собрать по частям и нормализовать путь в YT
     *
     * @param basePath  базовая часть пути
     * @param pathParts оставщиеся части, будут добавлены в путь последовательно, после чего он будет нормализован
     */
    public static String generatePath(String basePath, String... pathParts) {
        return "/" + Paths.get(basePath, pathParts).normalize().toAbsolutePath().toString();
    }

    /**
     * Нормализовать путь в YT
     */
    public static String normalizePath(String path) {
        return generatePath(path);
    }

    /**
     * Сгенерировать случайный уникальный путь для временного файла/таблицы
     */
    public static String generateTemporaryPath() {
        return generatePath(TEMPORARY_TABLES_STORAGE, UUID.randomUUID().toString());
    }
}
