package ru.yandex.direct.ytwrapper.client;

import javax.annotation.Nullable;

import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.yql.response.yt.AclDto;

/**
 * Конфигурация кластера
 */
public interface YtClusterConfig {
    String DEFAULT_YT_TOKEN_PATH = "~/.yt/token";
    String DEFAULT_YQL_TOKEN_PATH = "~/.yt/yql_token";

    int DEFAULT_YT_PROXY_PORT = 80;

    /**
     * @return host HTTP-прокси
     */
    String getProxy();

    /**
     * @return аутентификационный токен
     */
    String getToken();

    /**
     * @return аутентификационный токен YQL
     */
    String getYqlToken();

    /**
     * @return Дефолтный ACL для YQL-операций
     */
    @Nullable
    default AclDto getDefaultYqlAcl() {
        return null;
    }

    /**
     * @return path домашней директории на кластере
     */
    String getHome();

    /**
     * @return имя пользователя для аутентификации
     */
    String getUser();

    YtCluster getCluster();

    default String getProxyHost() {
        String proxy = getProxy();
        if (proxy.contains(":")) {
            return proxy.split(":")[0];
        }
        return proxy;
    }

    default int getProxyPort() {
        String proxy = getProxy();
        if (proxy.contains(":")) {
            return Integer.parseInt(proxy.split(":")[1]);
        }
        return DEFAULT_YT_PROXY_PORT;
    }
}
