package ru.yandex.direct.ytwrapper.client;

import javax.annotation.ParametersAreNonnullByDefault;

import com.typesafe.config.Config;

import ru.yandex.direct.ytwrapper.model.YtCluster;

/**
 * Реализация {@link YtClusterConfigProvider} поверх Typesafe'ного {@link Config}.
 */
@ParametersAreNonnullByDefault
public class YtClusterTypesafeConfigProvider implements YtClusterConfigProvider {

    private final Config ytConfig;

    /**
     * @param ytConfig ветка конфигурации подключения к кластерам YT. Обычно ветка называется {@code "yt"}
     */
    public YtClusterTypesafeConfigProvider(Config ytConfig) {
        this.ytConfig = ytConfig;
    }

    @Override
    public YtClusterConfig get(YtCluster cluster) {
        String clusterName = cluster.getName();
        return new YtClusterTypesafeConfig(cluster, ytConfig.getConfig(clusterName));
    }
}
