package ru.yandex.direct.ytwrapper.dynamic;

import java.time.Duration;

import ru.yandex.yt.ytclient.rpc.internal.Compression;

/**
 * Конфигурация для работы с динамическими таблицами YT
 */
public interface YtDynamicConfig {

    /**
     * таймаут для операции {@code selectRows}.
     * не может превышать {@link #globalTimeout()}
     */
    Duration defaultSelectRowsTimeout();

    /**
     * максимально возможное значение таймаута (включая {@link #failoverTimeout()}) для любой операции
     */
    Duration globalTimeout();

    /**
     * таймаут, по истечении которого библиотека пытается сделать перезапрос через другую RPC-node
     */
    Duration failoverTimeout();

    /**
     * задает {@link ru.yandex.yt.ytclient.rpc.RpcOptions#setStreamingWriteTimeout(Duration)}
     * работает странно (возможно фичебаг в библиотеке YT): от открытия TableWriter и запись данных его не продлевает
     */
    Duration streamingWriteTimeout();

    /**
     * задает {@link ru.yandex.yt.ytclient.rpc.RpcOptions#setStreamingReadTimeout(Duration)}
     */
    Duration streamingReadTimeout();

    /**
     * @return значение для параметра {@code input-rows-limit}, определяющего размер входа операции в YT
     */
    Long inputRowsLimit();

    /**
     * @return значение для параметра {@code output-rows-limit}, определяющего размер выхода операции в YT
     */
    Long outputRowsLimit();

    Compression requestCodecId();

    Compression responseCodecId();

}
