package ru.yandex.direct.ytwrapper.dynamic;

import java.time.Duration;

import com.typesafe.config.Config;

import ru.yandex.yt.ytclient.rpc.internal.Compression;

/**
 * Реализация {@link YtDynamicConfig} поверх Typesafe'ного {@link Config}.
 */
public class YtDynamicTypesafeConfig implements YtDynamicConfig {

    private final Config ytConfig;

    /**
     * @param ytConfig ветка конфигурации подключения к кластерам YT. Обычно ветка называется {@code "yt"}
     */
    public YtDynamicTypesafeConfig(Config ytConfig) {
        this.ytConfig = ytConfig;
    }

    /**
     * @return значение параметра {@code "default-select-rows-timeout"} из конфигурации YT
     */
    @Override
    public Duration defaultSelectRowsTimeout() {
        return ytConfig.getDuration("default-select-rows-timeout");
    }

    @Override
    public Duration globalTimeout() {
        return ytConfig.getDuration("global-timeout");
    }

    @Override
    public Duration failoverTimeout() {
        return ytConfig.getDuration("failover-timeout");
    }

    @Override
    public Duration streamingWriteTimeout() {
        return ytConfig.getDuration("streaming-write-timeout");
    }

    @Override
    public Duration streamingReadTimeout() {
        return ytConfig.getDuration("streaming-read-timeout");
    }

    /**
     * @return значение параметра {@code "input-rows-limit"} из конфигурации YT
     */
    @Override
    public Long inputRowsLimit() {
        return ytConfig.getLong("input-rows-limit");
    }

    /**
     * @return значение параметра {@code "output-rows-limit"} из конфигурации YT
     */
    @Override
    public Long outputRowsLimit() {
        return ytConfig.getLong("output-rows-limit");
    }

    @Override
    public Compression requestCodecId() {
        return ytConfig.getEnum(Compression.class, "request-codec-id");
    }

    @Override
    public Compression responseCodecId() {
        return ytConfig.getEnum(Compression.class, "response-codec-id");
    }
}
