package ru.yandex.direct.ytwrapper.dynamic.context;

import java.time.Duration;
import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterChooser;
import ru.yandex.direct.ytwrapper.model.YtCluster;

/**
 * Позволяет получить {@link YtDynamicContext} для выполнения запросов к динамическим таблицам YT
 */
public class YtDynamicContextProvider<P> {
    private final ClusterChooser<P> clusterChooser;
    private final YtProvider ytProvider;
    private final Duration timeout;

    public YtDynamicContextProvider(
            ClusterChooser<P> clusterChooser,
            YtProvider ytProvider,
            Duration timeout) {
        this.clusterChooser = clusterChooser;
        this.ytProvider = ytProvider;
        this.timeout = timeout;
    }

    /**
     * Возвращает {@link YtDynamicContext} выбранный {@link ClusterChooser} для параметра {@code params}.
     */
    public YtDynamicContext getContext(@Nullable P params) {
        Optional<List<YtCluster>> clustersOptional = clusterChooser.getClustersOrdered(params);
        List<YtCluster> clustersByPriority =
                clustersOptional.orElseThrow(() -> new IllegalStateException("No clusters available"));

        // Сейчас доступных кластеров немного, поэтому отдаём в context все, что получили
        return new YtDynamicContext(ytProvider, clustersByPriority, timeout);
    }

    /**
     * Возвращает {@link YtDynamicContext} по умолчанию.
     *
     * @see ClusterChooser
     */
    public YtDynamicContext getContext() {
        return getContext(null);
    }
}
