package ru.yandex.direct.ytwrapper.dynamic.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;

import ru.yandex.direct.tracing.Trace;

/**
 * Контейнер для сбора лог-информации о запросе в YT.
 * Пишется в виде JSON в лог.
 */
public class YtQueryLogRecord {
    private final String query;
    private final long startTime;
    private long finishTime;

    private final long spanId;
    private final String service;
    private final String method;

    private String error;
    private int resultRows;

    public YtQueryLogRecord(String query) {
        this.query = query;

        Trace trace = Trace.current();
        this.spanId = trace.getSpanId();
        this.service = trace.getService();
        this.method = trace.getMethod();

        this.startTime = System.nanoTime();
    }

    public void setException(Exception ex) {
        stopTimer();
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));

        error = sw.toString();
    }

    public void setResultRows(int resultRows) {
        stopTimer();
        this.resultRows = resultRows;
    }

    public double getEla() {
        stopTimer();
        return ((double) (finishTime - startTime)) / TimeUnit.SECONDS.toNanos(1);
    }

    private void stopTimer() {
        if (finishTime == 0) {
            finishTime = System.nanoTime();
        }
    }

    public long getSpanId() {
        return spanId;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    public String getQuery() {
        return query;
    }

    public String getError() {
        return error;
    }

    public int getResultRows() {
        return resultRows;
    }
}
