package ru.yandex.direct.ytwrapper.dynamic.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Логгирование запросов в YT, умеет писать запросы в JSON-формате и человеко-понятном
 */
public class YtQueryLogger {
    private static final Logger logger = LoggerFactory.getLogger(YtQueryLogger.class);

    private YtQueryLogger() {
    }

    /**
     * Залогировать запрос.
     */
    public static void log(YtQueryLogRecord rec) {
        if (logger.isDebugEnabled()) {
            logger.debug(prettyFormat(rec));
        }
    }

    private static String prettyFormat(YtQueryLogRecord rec) {
        StringBuilder sb = new StringBuilder();
        sb.append(rec.getService())
                .append('/')
                .append(rec.getMethod())
                .append('/')
                .append(rec.getSpanId())
                .append('\n');
        sb.append(rec.getQuery()).append('\n');
        sb.append("Elapsed: ").append(rec.getEla())
                .append(", resultRows: ").append(rec.getResultRows());
        if (rec.getError() != null) {
            sb.append("Error: ").append(rec.getError());
        }
        return sb.toString();
    }
}
