package ru.yandex.direct.ytwrapper.dynamic.selector;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public interface ClusterChooser<P> {

    /**
     * Возвращает самый подходящий кластер
     */
    @Nonnull
    Optional<YtCluster> getCluster(@Nullable P param);

    /**
     * Возвращает самый подходящий кластер
     */
    @Nonnull
    default Optional<YtCluster> getCluster() {
        return getCluster(null);
    }

    /**
     * Возвращает список доступных кластеров в том порядке, в котором к ним необходимо обращаться
     */
    @Nonnull
    default Optional<List<YtCluster>> getClustersOrdered(@Nullable P param) {
        return getCluster(param).map(Collections::singletonList);
    }

    /**
     * Возвращает список доступных кластеров в том порядке, в котором к ним необходимо обращаться
     */
    @Nonnull
    default Optional<List<YtCluster>> getClustersOrdered() {
        return getClustersOrdered(null);
    }

}
