package ru.yandex.direct.ytwrapper.dynamic.selector;

import org.jooq.impl.TableImpl;

import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

public class QueryBasedClusterWeightFunction implements ClusterWeightFunction {

    protected final YtProvider ytProvider;
    protected final TableImpl table;
    private final TableAvailabilityChecker tableAvailabilityChecker;

    public QueryBasedClusterWeightFunction(TableAvailabilityChecker tableAvailabilityChecker,
                                           YtProvider ytProvider, TableImpl table) {
        this.ytProvider = ytProvider;
        this.table = table;
        this.tableAvailabilityChecker = tableAvailabilityChecker;
    }

    @Override
    public ClusterFreshness apply(YtCluster ytCluster) {
        YtDynamicOperator ytDynamicOperator = ytProvider.getDynamicOperator(ytCluster);

        if (!tableAvailabilityChecker.isTableAvailable(ytDynamicOperator, table)) {
            return ClusterFreshness.UNAVAILABLE;
        }

        return calcFreshness(ytCluster);
    }

    protected ClusterFreshness calcFreshness(YtCluster ignored) {
        return ClusterFreshness.FRESH;
    }
}
