package ru.yandex.direct.ytwrapper.dynamic.selector;

import java.util.List;
import java.util.Optional;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.ytwrapper.model.YtCluster;

import static com.google.common.base.Preconditions.checkArgument;

public class TestClusterChooser implements ClusterChooser<Void> {
    private final YtCluster cluster;

    public TestClusterChooser(YtCluster cluster) {
        checkArgument(cluster != null, "Cluster is required");
        this.cluster = cluster;
    }

    @NotNull
    @Override
    public Optional<YtCluster> getCluster(@Nullable Void param) {
        return Optional.of(cluster);
    }

    @NotNull
    @Override
    public Optional<List<YtCluster>> getClustersOrdered(@Nullable Void param) {
        return Optional.of(List.of(cluster));
    }
}
