package ru.yandex.direct.ytwrapper.model;

import org.slf4j.Logger;

import ru.yandex.direct.utils.MonotonicClock;
import ru.yandex.direct.utils.NanoTimeClock;
import ru.yandex.yt.ytclient.proxy.ApiServiceTransaction;

abstract class TxWaitingWrapper {
    protected static final MonotonicClock clock = NanoTimeClock.CLOCK;
    protected final YtDynamicOperator operator;
    protected final ApiServiceTransaction tx;

    protected volatile boolean shutdown;

    TxWaitingWrapper(YtDynamicOperator operator, ApiServiceTransaction tx) {
        this.operator = operator;
        this.tx = tx;
        shutdown = false;
    }

    public void interrupt() {
        shutdown = true;
    }


    public void commitTx() {
        getLogger().info("Commit tx {}", tx);
        operator.runRpcCommandWithTimeout(tx::commit);
    }

    public void abortTx() {
        getLogger().info("Abort tx {}", tx);
        operator.runRpcCommandWithTimeout(tx::abort);
    }

    public void pingTx() {
        getLogger().info("Ping tx {}", tx);
        operator.runRpcCommandWithTimeout(tx::ping);
    }

    protected abstract Logger getLogger();
}
