package ru.yandex.direct.ytwrapper.model;

import ru.yandex.yql.response.yt.AclDto;

public class YqlQuery {
    private String sql;
    private Object[] binds;
    private String title;
    private AclDto acl;

    public YqlQuery(String sql, Object... binds) {
        this.sql = sql;
        this.binds = binds;
    }

    public YqlQuery withTitle(String title) {
        this.title = title;
        return this;
    }

    public YqlQuery withAcl(AclDto acl) {
        this.acl = acl;
        return this;
    }

    public String getSql() {
        return sql;
    }

    public Object[] getBinds() {
        return binds;
    }

    public String getTitle() {
        return title;
    }

    public AclDto getAcl() {
        return acl;
    }
}
