package ru.yandex.direct.ytwrapper.model;

import java.sql.ResultSet;

import ru.yandex.direct.utils.InterruptedRuntimeException;
import ru.yandex.direct.ytwrapper.exceptions.RuntimeYqlException;

@FunctionalInterface
public interface YqlRowMapper<T> {
    T mapRow(ResultSet rs) throws Exception;

    default T mapRowSafely(ResultSet rs) {
        try {
            return mapRow(rs);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedRuntimeException(e);
        } catch (Exception e) {
            throw new RuntimeYqlException(e);
        }
    }
}
