package ru.yandex.direct.ytwrapper.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Кластеры, доступные для работы
 */
public enum YtCluster {
    HAHN,
    ARNOLD,
    FREUD,
    LOCKE,
    MARKOV,
    ZENO,
    SENECA_MAN("seneca-man"),
    SENECA_SAS("seneca-sas"),
    SENECA_VLA("seneca-vla"),
    YT_LOCAL,
    ;

    private static final Map<String, YtCluster> ENUMS =
            Arrays.stream(values()).collect(Collectors.toMap(YtCluster::getName, Function.identity()));

    public static YtCluster parse(String name) {
        YtCluster result = ENUMS.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown cluster name " + name);
        }
        return result;
    }

    public static Set<String> getNames() {
        return ENUMS.keySet();
    }

    private final String name;

    YtCluster() {
        this(null);
    }

    YtCluster(String name) {
        this.name = name;
    }

    public String getName() {
        if (name == null) {
            return name().toLowerCase();
        }
        return name;
    }

    public static YtCluster clusterFromNameToUpperCase(String clusterName) {
        return YtCluster.valueOf(clusterName.replace("-", "_").toUpperCase(Locale.ROOT));
    }
}
