package ru.yandex.direct.ytwrapper.model;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.types.YsonTableEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * Базовый класс маппера
 */
@ParametersAreNonnullByDefault
public abstract class YtMapper implements Mapper<YTreeMapNode, YTreeMapNode> {
    private final YtTableRow mapTableRow = new YtTableRow();
    private final YtYield ytYield;

    public YtMapper(YtYield ytYield) {
        this.ytYield = ytYield;
    }

    public YtMapper() {
        this(new YtYield());
    }

    @Override
    public void map(YTreeMapNode node, Yield<YTreeMapNode> yield, Statistics statistics) {
        ytYield.setYield(yield);

        mapTableRow.setData(node);
        map(mapTableRow);
    }

    /**
     * Обработать одну строку из входных данных.
     * <p>
     * ВАЖНО: Объект tableRow всегда один и тот же, меняются только данные в нем. Поэтому, сохранять этот объект,
     * чтобы использовать чуть позже - это плохая идея
     */
    public abstract void map(YtTableRow tableRow);

    /**
     * Отправить строку в вывод
     *
     * @param tableIndex индекс результирующей таблицы (если вывод производится в более чем одну строку)
     * @param tableRow   строка данных
     */
    protected void yield(int tableIndex, YtTableRow tableRow, List<YtField> fieldsToStrip) {
        ytYield.yield(tableIndex, tableRow, fieldsToStrip);
    }

    /**
     * Отправить строку в вывод
     *
     * @param tableIndex индекс результирующей таблицы (если вывод производится в более чем одну строку)
     * @param tableRow   строка данных
     */
    protected void yield(int tableIndex, YtTableRow tableRow) {
        this.yield(tableIndex, tableRow, Collections.emptyList());
    }

    /**
     * Отправить строку в вывод в таблицу по умолчанию с индексом 0
     *
     * @param tableRow строка данных
     */
    protected void yield(YtTableRow tableRow) {
        this.yield(0, tableRow);
    }

    /**
     * Отправить строку в вывод в таблицу по умолчанию с индексом 0
     *
     * @param tableRow строка данных
     */
    protected void yield(YtTableRow tableRow, List<YtField> fieldsToStrip) {
        this.yield(0, tableRow, fieldsToStrip);
    }

    @Override
    public final YTableEntryType<YTreeMapNode> inputType() {
        return new YsonTableEntryType(true, false);
    }

    @Override
    public final YTableEntryType<YTreeMapNode> outputType() {
        return new YsonTableEntryType(false, false);
    }
}
