package ru.yandex.direct.ytwrapper.model;

import java.util.Iterator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeIgnoreField;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.types.YsonTableEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * Базовый класс редьюсера с одним ключом
 *
 * @param <K> Тип ключа
 */
@ParametersAreNonnullByDefault
public abstract class YtReducer<K> implements ReducerWithKey<YTreeMapNode, YTreeMapNode, K> {
    @YTreeIgnoreField
    private YtYield ytYield;
    @YTreeIgnoreField
    private YtTableRow reduceTableRow = new YtTableRow();

    public YtReducer() {
        this(new YtYield());
    }

    public YtReducer(YtYield ytYield) {
        this.ytYield = ytYield;
    }

    /**
     * Отправить строку в вывод
     *
     * @param tableIndex индекс результирующей таблицы (если вывод производится в более чем одну строку)
     * @param tableRow   строка данных
     */
    protected void yield(int tableIndex, YtTableRow tableRow) {
        ytYield.yield(tableIndex, tableRow);
    }

    /**
     * Отправить строку в вывод в таблицу по умолчанию с индексом 0
     *
     * @param tableRow строка данных
     */
    protected void yield(YtTableRow tableRow) {
        this.yield(0, tableRow);
    }

    @Override
    public void start(Yield<YTreeMapNode> yield, Statistics statistics) {
        if (ytYield == null) {
            ytYield = new YtYield();
        }
        if (reduceTableRow == null) {
            reduceTableRow = new YtTableRow();
        }
    }

    @Override
    public final YTableEntryType<YTreeMapNode> inputType() {
        return new YsonTableEntryType(true, false);
    }

    @Override
    public final YTableEntryType<YTreeMapNode> outputType() {
        return new YsonTableEntryType(true, false);
    }

    @Override
    public final K key(YTreeMapNode entry) {
        reduceTableRow.setData(entry);
        return key(reduceTableRow);
    }

    @Override
    public final void reduce(K k, IteratorF<YTreeMapNode> entries, Yield<YTreeMapNode> yield, Statistics statistics) {
        ytYield.setYield(yield);
        reduce(k, entries.map(reduceTableRow::withData));
    }

    /**
     * Получить значение ключа из строки входной таблицы
     */
    public abstract K key(YtTableRow row);

    /**
     * Обработать набор строк с заданным ключом
     */
    public abstract void reduce(K k, Iterator<YtTableRow> entries);
}
