package ru.yandex.direct.ytwrapper.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

import static ru.yandex.direct.ytwrapper.model.YtTableRow.TABLE_INDEX_ATTR_NAME;

/**
 * Базовый класс маппера
 */
@ParametersAreNonnullByDefault
public class YtTableIndexMapper extends YtMapper {
    @Override
    public final void map(YTreeMapNode node, Yield<YTreeMapNode> yield, Statistics statistics) {
        int tableIndex = node.removeAttribute(TABLE_INDEX_ATTR_NAME).get().intValue();
        YtTableRow.TI_FIELD.insertValue(node, tableIndex);

        yield.yield(0, node);
    }

    @Override
    public final void map(YtTableRow tableRow) {
        throw new UnsupportedOperationException();
    }
}
