package ru.yandex.direct.ytwrapper.model;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * Объект, занимающийся отправкой рядов данных в вывод маппера или редьюсера для дальнейшей обработки кластером
 */
@ParametersAreNonnullByDefault
public class YtYield {
    private Yield<YTreeMapNode> yield;

    void setYield(Yield<YTreeMapNode> yield) {
        this.yield = yield;
    }

    /**
     * Отправить строку в вывод с заданным индексом выходной таблицы
     */
    public void yield(int tableIndex, YtTableRow tableRow) {
        this.yield(tableIndex, tableRow, Collections.emptyList());
    }

    /**
     * Отправить строку в вывод с заданным индексом выходной таблицы и заданными полями
     */
    public void yield(int tableIndex, YtTableRow tableRow, List<YtField> fieldsToStrip) {
        YTreeMapNode node = tableRow.getStrippedData(fieldsToStrip);
        yield.yield(tableIndex, node);
    }
}
