package ru.yandex.direct.ytwrapper.schemagen;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.ytwrapper.client.YtClusterConfig;

class SchemaGeneratorParams {
    @Parameter(
            names = {"-p", "--proxy"},
            required = true,
            description = "YT-proxy to use"
    )
    String proxy;

    @Parameter(
            names = {"-t", "--token-path"},
            description = "Path to YT-token"
    )
    String token = YtClusterConfig.DEFAULT_YT_TOKEN_PATH;

    @Parameter(
            names = {"-o", "--output-path"},
            required = true,
            description = "Where to place generated code"
    )
    String outputPath;

    @Parameter(
            names = {"-c", "--config"},
            required = true,
            description = "Path to config file"
    )
    String configPath;

    @Parameter(
            names = {"-u"},
            description = "Use user attribute to get schema"
    )
    boolean useUserSchema;
}
