package ru.yandex.direct.ytwrapper.specs;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * Спецификация операции удаления ноды (таблицы/файла/etc) в YT
 */
@ParametersAreNonnullByDefault
public class DeleteNodeOperationSpec implements OperationSpec {
    private final YPath yPath;

    DeleteNodeOperationSpec(YPath path) {
        this.yPath = path;
    }

    public YPath getYPath() {
        return yPath;
    }

    @Override
    public void run(Yt yt, GUID transactionUID) {
        boolean pingTransaction = transactionUID != null;

        yt.cypress().remove(Optional.ofNullable(transactionUID), pingTransaction, yPath);
    }
}
