package ru.yandex.direct.ytwrapper.specs;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ytwrapper.exceptions.SpecGenerationException;
import ru.yandex.direct.ytwrapper.model.YtTable;

@ParametersAreNonnullByDefault
public class DeleteTableSpecBuilder extends AppendableSpecBuilder {
    private YtTable getTableToDelete() {
        return getInputTables().get(0).getTable();
    }

    @Override
    protected OperationSpec buildCurrent() {
        return new DeleteNodeOperationSpec(getTableToDelete().ypath());
    }

    @Override
    public void validateCurrent() {
        if (getInputTables().isEmpty()) {
            throw new SpecGenerationException("No tables to delete");
        } else if (getInputTables().size() > 1) {
            throw new SpecGenerationException("Can delete only one table a time");
        }
    }

    @Override
    public String toString() {
        return String.format("DeleteTable(%s)", getTableToDelete());
    }
}
