package ru.yandex.direct.ytwrapper.specs;

import java.time.Duration;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.MergeSpec;

/**
 * Спецификация операции изменения аттрибутов таблицы, для которых нужно перемержить эту таблицу
 */
@ParametersAreNonnullByDefault
public class SetTableAttributesOperationSpec implements OperationSpec {
    private final YPath yPath;
    private final MergeSpec spec;
    private final Duration timeout;

    SetTableAttributesOperationSpec(YPath path, MergeSpec spec, Duration timeout) {
        this.yPath = path;
        this.spec = spec;
        this.timeout = timeout;
    }

    public YPath getYPath() {
        return yPath;
    }

    public MergeSpec getSpec() {
        return spec;
    }

    @Override
    public void run(Yt yt, GUID transactionUID) {
        Optional<GUID> optionalTransaction = Optional.ofNullable(transactionUID);
        boolean pingTransaction = transactionUID != null;

        if (yt.cypress().exists(optionalTransaction, pingTransaction, yPath)) {
            yt.cypress().remove(optionalTransaction, pingTransaction, yPath);
        }

        Operation operation = yt.operations().mergeAndGetOp(optionalTransaction, pingTransaction, spec);
        operation.awaitAndThrowIfNotSuccess(timeout);
    }
}
