package ru.yandex.direct.ytwrapper.specs;

import java.time.Duration;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.ytwrapper.exceptions.OperationRunningException;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.MapReduceSpec;
import ru.yandex.inside.yt.kosher.operations.specs.ReduceSpec;
import ru.yandex.inside.yt.kosher.operations.specs.SortSpec;
import ru.yandex.inside.yt.kosher.operations.specs.Spec;

/**
 * Спецификация операции для табличной операции (https://wiki.yandex-team.ru/yt/userdoc/operations/)
 */
@ParametersAreNonnullByDefault
public class SingleOperationSpec implements OperationSpec {
    private static final Logger logger = LoggerFactory.getLogger(SingleOperationSpec.class);

    private final Spec spec;
    private final Duration timeout;

    SingleOperationSpec(Spec spec, Duration timeout) {
        this.spec = spec;
        this.timeout = timeout;
    }

    public Spec getSpec() {
        return spec;
    }

    @Override
    public void run(Yt yt, GUID transactionUID) {
        Optional<GUID> optionalTransaction = Optional.ofNullable(transactionUID);
        boolean pingTransaction = transactionUID != null;

        Operation operation;
        logger.info("Start YT-job {}", spec);
        if (spec instanceof MapReduceSpec) {
            operation = yt.operations().mapReduceAndGetOp(optionalTransaction, pingTransaction, (MapReduceSpec) spec);
        } else if (spec instanceof ReduceSpec) {
            operation = yt.operations().reduceAndGetOp(optionalTransaction, pingTransaction, (ReduceSpec) spec);
        } else if (spec instanceof SortSpec) {
            operation = yt.operations().sortAndGetOp(optionalTransaction, pingTransaction, (SortSpec) spec);
        } else {
            throw new OperationRunningException("Unknown spec " + spec);
        }
        operation.awaitAndThrowIfNotSuccess(timeout);
        logger.info("YT-job {} finished", spec);
    }
}
