package ru.yandex.direct.ytwrapper.specs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.direct.ytwrapper.exceptions.SpecGenerationException;
import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTable;
import ru.yandex.inside.yt.kosher.operations.specs.SortSpec;

@ParametersAreNonnullByDefault
public class SortSpecBuilder extends AppendableSpecBuilder {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofHours(1);

    private List<YtField<?>> sortByFields = new ArrayList<>();

    @Override
    public SortSpecBuilder addInputTable(YtTable ytTable) {
        return (SortSpecBuilder) super.addInputTable(ytTable);
    }

    @Override
    public SortSpecBuilder addInputTables(Collection<YtTable> ytTables) {
        return (SortSpecBuilder) super.addInputTables(ytTables);
    }

    public SortSpecBuilder addInputTablesAndRows(Collection<TableRowPair> tableRowPairs) {
        return (SortSpecBuilder) super.addInputTablesAndRows(tableRowPairs);
    }

    public SortSpecBuilder setOutputTable(YtTable ytTable) {
        return (SortSpecBuilder) addOutputTable(ytTable);
    }

    public SortSpecBuilder addSortByFields(Collection<YtField<?>> ytFields) {
        sortByFields.addAll(ytFields);
        return this;
    }

    public SortSpecBuilder addSortByField(YtField<?> ytField) {
        sortByFields.add(ytField);
        return this;
    }

    @Override
    public void validateCurrent() {
        if (getInputTables().isEmpty()) {
            throw new SpecGenerationException("No input tables provided");
        } else if (getOutputTables().isEmpty()) {
            throw new SpecGenerationException("No output table provided");
        } else if (getOutputTables().size() > 1) {
            throw new SpecGenerationException("Too much output tables provided");
        } else if (sortByFields.isEmpty()) {
            throw new SpecGenerationException("No sort-by fields provided");
        }
    }

    private YtTable getOutputTable() {
        return getOutputTables().get(0);
    }

    @Override
    protected OperationSpec buildCurrent() {
        SortSpec spec = new SortSpec(
                Cf.wrap(getInputTables()).map(it -> it.getTable().ypath()),
                getOutputTable().ypath(),
                Cf.wrap(sortByFields).map(YtField::getName)
        );
        return new SingleOperationSpec(spec, getOperationTimeout() == null ? DEFAULT_TIMEOUT : getOperationTimeout());
    }

    @Override
    public String toString() {
        return String
                .format("SortTables(input=%s, output=%s, keys=%s)", getInputTables(), getOutputTable(), sortByFields);
    }
}
