package ru.yandex.direct.ytwrapper.utils;

import java.time.Duration;

import org.jooq.impl.TableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.ytwrapper.dynamic.TableMappings;
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator;

public class TableAvailabilityChecker {

    private static final Logger logger = LoggerFactory.getLogger(TableAvailabilityChecker.class);

    private static final Duration SELECT_TIMEOUT = Duration.ofSeconds(4);

    private TableMappings tableMappings;

    public TableAvailabilityChecker(TableMappings tableMappings) {
        this.tableMappings = tableMappings;
    }

    public boolean isTableAvailable(YtDynamicOperator ytDynamicOperator, TableImpl table) {
        String field = table.field(0).getName();
        String statTablePath = tableMappings.getTableMappings().get(table);
        // Считаем кластер доступным, если можем сделать к нему запрос
        try {
            ytDynamicOperator.selectRows(
                    field + " FROM [" + statTablePath + "] LIMIT 1", SELECT_TIMEOUT);
        } catch (RuntimeException e) {
            logger.warn("Error on check cluster availability", e);
            return false;
        }

        return true;
    }
}
