package ru.yandex.direct.zorafetcher;

import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;

import ru.yandex.direct.asynchttp.Result;

public class ZoraGoResponse extends ZoraResponse {

    public static final String X_YA_ERROR_CODE = "X-Ya-GoZora-Error-Code";
    public static final int ZORA_ERROR_HTTP_CODE = 599;

    public ZoraGoResponse(Response response) {
        super(response);
    }

    @Override
    public boolean isOk() {
        return response.getStatusCode() == HttpConstants.ResponseStatusCodes.OK_200;
    }

    @Override
    public boolean isNotOkByZora() {
        return !isOk() && response.getStatusCode() == ZORA_ERROR_HTTP_CODE;
    }

    @Override
    public int getZoraStatusCode() {
        return response.getStatusCode() == ZORA_ERROR_HTTP_CODE
                ? Integer.parseInt(response.getHeader(X_YA_ERROR_CODE))
                : response.getStatusCode();
    }

    @Override
    public boolean isTimeout(Result<ZoraResponse> result) {
        return result.isTimeout();
    }
}
