package ru.yandex.direct.zorafetcher;

import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants.ResponseStatusCodes;

import ru.yandex.direct.asynchttp.Result;

public class ZoraOnlineResponse extends ZoraResponse {

    public static final String X_YANDEX_HTTP_CODE = "X-Yandex-Http-Code";
    public static final String X_YANDEX_ORIG_HTTP_CODE = "X-Yandex-Orig-Http-Code";
    public static final String OK_200_STRING = String.valueOf(ResponseStatusCodes.OK_200);

    private static final int ZORA_TIMEOUT_CODE = 1031;

    public ZoraOnlineResponse(Response response) {
        super(response);
    }

    /**
     * Сайт ответил Zora'е {@code "OK 200"}
     */
    @Override
    public boolean isOk() {
        String header = response.getHeader(X_YANDEX_ORIG_HTTP_CODE);
        return header != null && header.equals(OK_200_STRING);
    }

    @Override
    public boolean isNotOkByZora() {
        return response.getHeaders().contains(X_YANDEX_HTTP_CODE);
    }

    @Override
    public int getZoraStatusCode() {
        return Integer.parseInt(response.getHeader(X_YANDEX_HTTP_CODE));
    }

    @Override
    public boolean isTimeout(Result<ZoraResponse> result) {
        return isNotOkByZora() && getZoraStatusCode() == ZORA_TIMEOUT_CODE;
    }

    public String getStatusText() {
        return response.getStatusText();
    }

    public String prettyZoraResponse() {
        StringBuilder sb = new StringBuilder();
        sb.append("statusCode=").append(response.getStatusCode()).append('\n')
                .append("headers={\n");
        for (var header : response.getHeaders()) {
            sb.append("  ").append(header.getKey())
                    .append(": ").append(header.getValue())
                    .append('\n');
        }
        sb.append('}');
        return sb.toString();
    }
}
