package ru.yandex.direct.zorafetcher;

import java.util.function.Function;

import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import ru.yandex.direct.asynchttp.ParsableRequest;

public abstract class ZoraRequest implements ParsableRequest<ZoraResponse> {

    private final long id;
    private final Request request;

    public ZoraRequest(long id, Request request) {
        this.id = id;
        this.request = request;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public Request getAHCRequest() {
        return request;
    }

    @Override
    public Function<Response, ZoraResponse> getParseFunction() {
        return this::parse;
    }

    protected abstract ZoraResponse parse(Response response);

    @Override
    public boolean isParsableResponse(Response response) {
        return true;
    }

    @Override
    public String toString() {
        return "ZoraRequest{" +
                "id=" + id +
                ", request=" + request +
                '}';
    }
}
