const chalk = require('chalk');

const COLORS = {
    error: 'red',
    warn: 'yellow',
    info: 'green',
    log: undefined,
};

// eslint-disable-next-line @typescript-eslint/no-explicit-any
function message(level = 'log', ...params) {
    let color = COLORS[level];

    // eslint-disable-next-line no-console
    console[level](`[${new Date().toISOString()}]`, ...params.map((val) => (color ? chalk[color](val) : val)));
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
function log(...params) {
    message('log', ...params);
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
function info(...params) {
    message('info', ...params);
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
function warn(...params) {
    message('warn', ...params);
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
function error(...params) {
    message('error', ...params);
}

module.exports = {
    log,
    info,
    warn,
    error,
};
