const logger = require('./logger');

module.exports = function webpackCompilerPromise(compiler) {
    return new Promise((resolve, reject) => {
        let name = compiler.name || 'development';

        compiler.hooks.compile.tap({ name }, () => {
            logger.info(`[${name}] compiling...`);
        });
        compiler.hooks.done.tap({ name }, (stats) => {
            if (!stats.hasErrors()) {
                logger.info(`[${name}] compiled successfully`);

                return resolve();
            }

            return reject(`Failed to compile ${name}`);
        });
    });
};
