const prettierConfig = require('./.config/lint/eslint-config-prettier');

module.exports = {
    extends: ['./node_modules/@yandex-int/lint/eslintrc.js'],
    plugins: ['simple-import-sort', 'typescript-sort-keys'],
    rules: {
        'jsx-a11y/media-has-caption': 'off',
        'arrow-parens': ['error', 'always'],
        'import/no-extraneous-dependencies': 'off',
        semi: 'error',
        'newline-before-return': 'error',
        'padding-line-between-statements': ['error', { blankLine: 'always', prev: 'if', next: 'if' }],
        'no-lonely-if': ['off'],
        '@typescript-eslint/no-non-null-assertion': 'off',

        // additional
        '@typescript-eslint/array-type': ['error', { default: 'array-simple' }],
        'import/order': 'off',
        'import/no-anonymous-default-export': ['error', { allowCallExpression: false }],
        'simple-import-sort/imports': [
            'error',
            {
                groups: [
                    // Node.js builtins. You could also generate this regex if you use a `.js` config
                    // For example: `^(${require("module").builtinModules.join("|")})(/|$)`
                    [
                        '^(assert|buffer|child_process|cluster|console|constants|crypto|dgram|dns|domain|events|fs|http|https|module|net|os|path|punycode|querystring|readline|repl|stream|string_decoder|sys|timers|tls|tty|url|util|vm|zlib|freelist|v8|process|async_hooks|http2|perf_hooks)(/.*|$)',
                    ],
                    // Packages. `react` related packages come first
                    ['^react', '^@?\\w'],
                    ['^secrets', '^(network|storage|server|state)(/.*|$)'],
                    // Apphost imports
                    ['^apphost/'],
                    // Schema imports
                    ['^schema/'],
                    // Standalone services imports
                    ['^standalone/'],
                    // Mutators imports
                    ['^mutators/'],
                    // Helpers imports
                    ['^helpers/'],
                    // Selectors imports
                    ['^selectors/'],
                    // Services imports
                    ['^services/'],
                    // Hooks imports
                    ['^hooks/'],
                    // Enums imports
                    ['^enums/'],
                    // Types imports
                    ['^types/'],
                    // Routes imports
                    ['^routes'],
                    // Tests imports
                    ['^story/', '^tests/'],
                    // Router imports
                    ['^router/'],
                    // Components imports
                    ['^components/'],
                    // Parent imports. Put `..` last
                    ['^\\.\\.(?!/?$)', '^\\.\\./?$'],
                    // Other relative imports. Put same-folder imports and `.` last
                    ['^\\./(?=.*/)(?!/?$)', '^\\.(?!/?$)', '^\\./?$'],
                    // Translates imports
                    ['^.+\\.i18n\\.ts$'],
                    // Images imports
                    ['^.+\\.ico$', '^.+\\.jpg$', '^.+\\.png$', '^.+\\.svg$'],
                    // Styles imports
                    ['^.+\\.s?css$'],
                ],
            },
        ],
        ...prettierConfig,
    },
};
