#!/bin/sh

# Скрипт заливает содержимое ./build в Sandbox и выводит resource_id полученного ресурса
# Запускать после
#   npm run build:prod

set -e

TMP=`mktemp -d`

tar cf $TMP/resource.tar -C build .

echo "upload to Sandbox..."
ya upload --ttl=inf --json-output $TMP/resource.tar > $TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)
echo "Resource ID: $RESOURCE_ID"

echo "Update frontend_resource/ya.make..."
# Делаем замену по регулярке в пятой строке
sed -i '' -E "5,5s/[[:digit:]]+/$RESOURCE_ID/" ../frontend_resource/ya.make

echo "Done."

