const https = require('https');
const express = require('express');
const chalk = require('chalk');
const webpack = require('webpack');
const webpackDevMiddleware = require('webpack-dev-middleware');
const webpackHotMiddleware = require('webpack-hot-middleware');
const { createProxyMiddleware } = require('http-proxy-middleware');
const openBrowser = require('react-dev-utils/openBrowser');
const webpackCompilerPromise = require('../.config/scripts/helpers/webpackCompilerPromise');

const PORT = process.env.PORT || 3000;
const HOST = process.env.HOST || 'localhost.yandex.ru';

const config = require('../.config/build/webpack.config.dev');
const fs = require('fs');

async function start(cert) {
    const compiler = webpack(config);
    const app = express();

    app.use(
        webpackDevMiddleware(compiler, {
            publicPath: config.output.publicPath,
        }),
    );
    app.use(webpackHotMiddleware(compiler));

    const proxySetting = require('../package.json').proxy;

    if (proxySetting) {
        Object.keys(proxySetting).forEach(function (context) {
            app.use(context, createProxyMiddleware(proxySetting[context]));
        });
    }

    let compilerPromise = webpackCompilerPromise(compiler);

    if (cert) {
        https.createServer(cert, app).listen(PORT, HOST);
    } else {
        app.listen(PORT, HOST);
    }

    await compilerPromise;

    // eslint-disable-next-line no-console
    console.log(chalk.cyan('Server is running on https://localhost.yandex.ru:3000/'));

    openBrowser('https://localhost.yandex.ru:3000/');
}

start({
    key: fs.readFileSync('secrets/device.key', 'utf8'),
    cert: fs.readFileSync('secrets/localhost.yandex.ru.crt', 'utf8'),
});
