import * as React from 'react';
import { useCallback, useMemo, useState } from 'react';
import { Checkbox, Popover } from 'antd';
import { PopoverProps } from 'antd/lib/popover';

import { cn } from 'helpers/className/className';

import './ColumnsSelect.css';

const CheckboxGroup = Checkbox.Group;

interface ColumnsSelectProps {
    className?: string;
    options: string[];
    value?: string[];
    disabled?: boolean;
    children: React.ReactNode;
    title: React.ReactNode;
    onChangeColumn: (fields: string[]) => void;
    placement?: PopoverProps['placement'];
}

const cls = cn('columns-select');

export const ColumnsSelect = React.memo(function ColumnsSelect({
    options,
    className,
    disabled,
    value,
    children,
    title,
    onChangeColumn,
    placement,
}: ColumnsSelectProps) {
    const [visible, setVisible] = useState(false);
    const content = useMemo(
        () => <CheckboxGroup value={value} className={cls('menu')} options={options} onChange={onChangeColumn} />,
        [onChangeColumn, options, value],
    );
    const onVisibleChange = useCallback(
        (value: boolean) => {
            if (disabled) {
                return;
            }

            setVisible(value);
        },
        [disabled],
    );

    return (
        <Popover
            content={content}
            title={title}
            trigger="click"
            visible={visible}
            placement={placement}
            onVisibleChange={onVisibleChange}
            className={cls(null, [className])}
        >
            {children}
        </Popover>
    );
});
