import * as React from 'react';
import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { BarChartOutlined } from '@ant-design/icons';
import { Checkbox, Select } from 'antd';

import { cn } from 'helpers/className/className';

import { getUIFilterFormLogTimeGroupBy } from 'selectors/ui/getUIFilterFormLogTimeGroupBy/getUIFilterFormLogTimeGroupBy';
import { getUIFilterFormShowStats } from 'selectors/ui/getUIFilterFormShowStats/getUIFilterFormShowStats';
import { getUIFilterFormSortByCount } from 'selectors/ui/getUIFilterFormSortByCount/getUIFilterFormSortByCount';

import { updateUIFilterForm } from 'services/filterForm/updateUIFilterForm/updateUIFilterForm';

import 'antd/dist/antd.css';
import './ShowStats.css';

const cls = cn('show-stats');

interface ShowStatsProps {
    className?: string;
}

const options = [
    {
        value: 'YEAR',
        label: 'year',
    },
    {
        value: 'MONTH',
        label: 'month',
    },
    {
        value: 'DAY',
        label: 'day',
    },
    {
        value: 'HOUR',
        label: 'hour',
    },
    {
        value: 'MINUTE',
        label: 'minute',
    },
];

export const ShowStats = React.memo(function (props: ShowStatsProps) {
    const dispatch = useDispatch();
    const logTimeGroupBy = useSelector(getUIFilterFormLogTimeGroupBy);
    const showStats = useSelector(getUIFilterFormShowStats);
    const sortByCount = useSelector(getUIFilterFormSortByCount);

    const onChangeGroupTime = useCallback(
        (value: string) => {
            dispatch(
                updateUIFilterForm({
                    logTimeGroupBy: value,
                }),
            );
        },
        [dispatch],
    );
    const onChangeShowStats = useCallback(
        (e) => {
            dispatch(
                updateUIFilterForm({
                    showStats: Boolean(e.target.checked),
                }),
            );
        },
        [dispatch],
    );
    const onChangeSortByCount = useCallback(
        (e) => {
            dispatch(
                updateUIFilterForm({
                    sortByCount: Boolean(e.target.checked),
                }),
            );
        },
        [dispatch],
    );

    return (
        <div className={cls(null, [props.className])}>
            <div className={cls('form')}>
                <Checkbox checked={showStats} onChange={onChangeShowStats}>
                    <div className={cls('title')}>
                        <BarChartOutlined className={cls('title-icon')} />
                        Show count stats
                    </div>
                </Checkbox>

                {showStats && (
                    <>
                        <label className={cls('inline-label')}>group log_time by</label>
                        <Select
                            id={'time-select'}
                            placeholder="-"
                            optionFilterProp="children"
                            size={'large'}
                            className={cls('time-select')}
                            onChange={onChangeGroupTime}
                            value={logTimeGroupBy}
                            allowClear
                            options={options}
                        />

                        <Checkbox checked={sortByCount} onChange={onChangeSortByCount}>
                            sort by count
                        </Checkbox>
                    </>
                )}
            </div>
        </div>
    );
});
