import * as React from 'react';
import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { Button, List, Spin } from 'antd';

import { HistoryItemSchema } from 'schema/history/HistorySchema';

import { cn } from 'helpers/className/className';

import { getHistory } from 'selectors/history/getHistory/getHistory';
import { getUIHistoryPanel } from 'selectors/ui/getUIHistoryPanel/getUIHistoryPanel';

import { loadHistory } from 'services/loadHistory/loadHistory';

import { HistoryPanelItem } from 'components/HistoryPanel/HistoryPanelItem/HistoryPanelItem';

import './HistoryPanel.css';
import { isLogsDataLoading } from 'selectors/logs/isLogsDataLoading/isLogsDataLoading';
import { isPageDataLoadingByQueryId } from 'selectors/logs/isPageDataLoadingByQueryId/isPageDataLoadingByQueryId';

const cls = cn('history-panel');

interface HistoryPanelProps {
    className?: string;
}

export const HistoryPanel = function HistoryPanel(props: HistoryPanelProps) {
    const dispatch = useDispatch();
    const { selectedQueryId } = useSelector(getUIHistoryPanel);
    const { isLoading, requestsList, isLoadNextChunkButtonHidden } = useSelector(getHistory);
    const onLoadMore = useCallback(() => {
        return dispatch(loadHistory({ loadNextChunk: true }));
    }, [dispatch]);

    const logsDataLoading = useSelector(isLogsDataLoading);
    const isPageDataLoadingByQueryIdValue = useSelector(isPageDataLoadingByQueryId);
    const isLogsLoading = logsDataLoading || isPageDataLoadingByQueryIdValue;
    const renderItem = useCallback(
        (item: HistoryItemSchema) => {
            return (
                <List.Item className={cls('list-item', { selected: selectedQueryId === item.queryId })}>
                    <HistoryPanelItem {...item} className={cls('item')} />
                </List.Item>
            );
        },
        [selectedQueryId]
    );

    return (
        <div className={cls({ loading: isLoading || isLogsLoading }, [props.className])}>
            {!isLogsLoading && <List dataSource={requestsList} renderItem={renderItem} />}
            {!isLogsLoading && !isLoading && !isLoadNextChunkButtonHidden && (
                <div className={cls('load-more')}>
                    <Button onClick={onLoadMore}>Loading more</Button>
                </div>
            )}
            {(isLoading || isLogsLoading) && <Spin className={cls('spin ')} />}
        </div>
    );
};
