import * as React from 'react';
import {
    CheckCircleOutlined,
    ClockCircleOutlined,
    ExclamationCircleOutlined,
    QuestionCircleOutlined,
} from '@ant-design/icons';

import { HistoryItemStatus } from 'schema/history/HistorySchema';

export const HistoryStatusIcon = React.memo(({ status }: { status: HistoryItemStatus }) => {
    switch (status) {
        case HistoryItemStatus.OK:
            return <CheckCircleOutlined style={{ color: 'rgb(7 163 0)' }} />;
        case HistoryItemStatus.FAIL:
            return <ExclamationCircleOutlined style={{ color: 'rgb(255 4 0)' }} />;
        case HistoryItemStatus.RUNNING:
            return <ClockCircleOutlined />;
        case HistoryItemStatus.UNKNOWN:
        default:
            return <QuestionCircleOutlined />;
    }
});
